#' Sum of the distance between the points in a group and a given center.
#'
#'
#' This function calculates the sum of the distance between the points in a group and a given center of the group. The function calculates these values for all groups and then adds them together. The user can choose which distance to choose.
#'
#'
#' @param data Matrix with \code{dim(data)[1]} points of \code{dim(data)[2]} dimensions.
#' @param distance Function. This function designs how the distance is going to be calculated. It must have as input two vectors and as output the distance of these vectors.
#' @param inicenters_v Vector. Vector with the centers of the groups that has more than one point. The centres are arranged by the number of the group. If a group has only one component, this center is not included in the vector. The vector contain all the components of the center of the first group (if this group has more than one point, otherwise the vector will start with the components of the center of the second group), then all the components of the center of the second group (if this group has more than one point), then all the components of the third group (if this group has more than one point), and so on until the center of all groups with more than one point are introduced.
#' @param grouping  List. Each component of the list contains a vector with the points that belong to that group. More specifically, the list component i has a vector with the numbers of the row of the matrix \code{data} where the points belonging to group i are.
#'
#'
#' @return Returns a number. First this function calculates the distance between each point of a group and its given center and sum these values. Then, the function sum the values obtained for each group. This is the output.
#'
#'
#'
#' @examples
#'
#' grouping=list(c(1,2,3),c(4,5),c(6,7))
#'set.seed(451)
#'data=t(gtools::rdirichlet(10, c(1,1,1,4,4,9,9)))
#'inicenters=runif(dim(data)[2]*length(grouping), 0.1, 0.9)
#'inicenters_v=as.vector(inicenters)
#'to_minimize(inicenters_v, data, grouping, Euclideandistance)
#'
#' @export



to_minimize<-function(inicenters_v, data, grouping, distance){

  long_groups=sapply(grouping, function(x) length(x) != 1)


  if(any(long_groups==FALSE)==TRUE){
    group_one=which(long_groups==FALSE)
    groups_more=which(long_groups==TRUE)


    inicenters=t(matrix(inicenters_v,dim(data)[2],length(groups_more)))

    dist_group=rep(0, length(groups_more))
    for(i in 1:length(groups_more)){
      vect=grouping[[groups_more[i]]]

      dist_point=rep(0, length(vect))
      for(m in 1:length(vect)){
        dist_point[m]=distance(data[vect[m],], inicenters[i,] )
      }

      dist_group[i]=sum(dist_point)
    }

    final=sum(dist_group)

    return(final)


  }


  if(all(long_groups==FALSE)==FALSE){
    inicenters=t(matrix(inicenters_v,dim(data)[2],length(grouping)))


    dist_group=rep(0, length(grouping))
    for(i in 1:length(grouping)){
      vect=grouping[[i]]

      dist_point=rep(0, length(vect))
      for(m in 1:length(vect)){
        dist_point[m]=distance(data[vect[m],], inicenters[i,] )
      }

      dist_group[i]=sum(dist_point)
    }

    final=sum(dist_group)

    return(final)
  }


}







