# load all functions declared in the package
devtools::load_all(reset = TRUE, compile = TRUE) # load all functions declared in the package

# Checking rasubbo vs rasubbo2 vs ralaplace
# rasubbo_orig is identical to rasubbo while having
# different ar parameters, because it doesn't attributes a new mass
# depending on the ratio of the al,ar parameters
set.seed(1)
rasubbo_orig(n = 1, m = 0, al = 1, ar = 2, bl = 1, br = 1)
set.seed(1)
rasubbo(n = 1, m = 0, al = 1, ar = 1, bl = 1, br = 1)

# to be consistent with ralaplace, the new rasubbo must
# be used
set.seed(1)
ralaplace(1, 0, 1, 2)
set.seed(1)
rasubbo(1, 0, 1, 2, 1, 1)



# psep numerical integration problem
#   There are some
#   problems with the numerical integration of the CDF of the Skewed Exponential Power.
#   Reasonably, one would not want to be bothered by sorting vectors to return the CDF
#   values, nor be surprised by this function call creating unforeseen problems, such as
#   modifying variables by reference instead of by value.So, I adapted the original
#   function to order a copy of the original vector passed and to return the CDF values
#   in the exact same order of the original, which makes it well-rounded to use in
#   dataframe contexts. However, since the routine uses numerical integration, and
#   particularly, two types, the intervals between the values matter. Currently, If I
#   sample two values with more than 5 orders of magnitude between them, the routines
#   produce wrong outputs. Ex: psep(c(1, 10^5)).
# works
psep(c(10^5))
psep(c(1))
# fails
psep(c(1, 10^5))
# solved by eliminating the quadrature by intervals (which makes sense for a
# cumulative plot but not to a random number probability evaluation)
x <- seq(-10, 10, by = 0.1)
y <- psep(x, 1, 1, 1, 0)
y
# extreme values above the location parameter also made the quadrature fail
# so I put an if clause to correct it
psep(seq(10, 100, 10), 0, 2, 1, 0)


psep(-1, m=0, a=1, b=2, lambda=0)