% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/additiveMatrix.R
\name{additiveMatrix}
\alias{additiveMatrix}
\title{Generate an additive approximation of a data matrix}
\usage{
additiveMatrix(mat)
}
\arguments{
\item{mat}{A numeric matrix or data frame with numeric entries.}
}
\value{
A numeric matrix of the same dimension as \code{mat}, approximating it
using an additive model.
}
\description{
Constructs a matrix with an additive structure based on the row means,
column means, and the grand mean of the original matrix.
}
\details{
The result is an approximation \eqn{A} of the original matrix, where:
\deqn{A[i,j] = rowMean[i] + colMean[j] - grandMean}
This model captures main additive effects of rows and columns, commonly
used in exploratory data analysis or baseline modeling.
}
\examples{
m <- matrix(c(1, 2, 3, 4), nrow = 2)
additiveMatrix(m)

}
