#' Supported copula types
#'
#' A list containing supported copula types.
#'
#' @format A list of copula types.
#' \describe{
#'   \item{copulas}{"Gaussian" "Clayton" "Frank" "Gumbel" "Joe"}
#' }
"copula_list"

#' Real crop yield and meteorological data of 24 regions for Ontario, Canada from 1950 to 2022 and anticipated data from 2023 to 2100.
#'
#' @format A data frame with 1752 rows and 27 variables:
#' \describe{
#'      \item{time}{chr: year from 1950-2022}
#'      \item{CD}{chr: 24 subregions}
#'      \item{lat}{num: latitude}
#'      \item{lon}{num: longitude}
#'      \item{yield}{num: wheat crop yield per census division, in bushel/acre}
#'      \item{cdd}{num: Annual maximum number of consecutive days with daily precipitation below 1mm (unit = days)}
#'      \item{cddcold}{num: Annual cooling degree days above 18C (unit = degree_days)}
#'      \item{dlyfrzthw}{num: Annual number of days with a diurnal freeze-thaw cycle : tmax > 0 degc and tmin <= -1 degc}
#'      \item{firstfallfrost}{num: First day of year with temperature below 0 degc for at least 1 days}
#'      \item{frostdays}{num: Annual number of days with minimum daily temperature below 0C}
#'      \item{icedays}{num: Annual number of days with maximum daily temperature below 0 degC}
#'      \item{nrcdd}{num: The annual number of dry periods of 6 days and more, during which the maximal precipitation on a window of 6 days is under 1.0 mm}
#'      \item{prcptot}{num: Annual total precipitation (unit = mm)}
#'      \item{r1mm}{num: Annual number of days with daily precipitation over 1.0 mm/day}
#'      \item{r10mm}{num: Annual number of days with daily precipitation over 10.0 mm/day}
#'      \item{r20mm}{num: Annual number of days with daily precipitation over 20.0 mm/day}
#'      \item{rx1day}{num: Annual maximum 1-day total precipitation (unit = mm)}
#'      \item{rx5day}{num: Annual maximum 5-day total precipitation (unit = mm)}
#'      \item{tgmean}{num: Annual mean of daily mean temperatures  (unit = C degrees)}
#'      \item{tnmean}{num: Annual mean of daily minimum temperatures (unit = C degrees)}
#'      \item{tnmin}{num: Annual minimum of daily minimum temperatures (unit = C degrees)}
#'      \item{tr18}{num: Annual number of tropical nights : defined as days with minimum daily temperature above 18 degc}
#'      \item{txmax}{num: Annual minimum of daily maximum temperature (unit = C degrees)}
#'      \item{txmean}{num: Annual mean of daily maximum temperature (unit = C degrees)}
#'      \item{txgt25}{num: Annual number of days where daily maximum temperature exceeds 25 degC}
#'      \item{txgt27}{num: Annual number of days where daily maximum temperature exceeds 27 degC}
#'      \item{txgt29}{num: Annual number of days where daily maximum temperature exceeds 29 degC}
#'      }
#'
#' @source ClimateData.ca
#'
"data"

#' Selected data from year 1950 to 2022 and covariates including txgt27, tr18, cddcold, txgt29, and tnmean for case study.
#'
#' @format A data frame with 1752 rows and 10 variables:
#' \describe{
#'      \item{time}{chr: year from 1950-2022}
#'      \item{CD}{chr: 24 subregions}
#'      \item{lat}{num: latitude}
#'      \item{lon}{num: longitude}
#'      \item{yield}{num: wheat crop yield per census division, in bushel/acre}
#'      \item{cddcold}{num: Annual cooling degree days above 18C (unit = degree_days)}
#'      \item{tnmean}{num: Annual mean of daily minimum temperatures (unit = C degrees)}
#'      \item{tr18}{num: Annual number of tropical nights : defined as days with minimum daily temperature above 18 degc}
#'      \item{txgt27}{num: Annual number of days where daily maximum temperature exceeds 27 degC}
#'      \item{txgt29}{num: Annual number of days where daily maximum temperature exceeds 29 degC}
#'      }
#'
#' @source ClimateData.ca
#'
"dt"

#' Initial Parameters for 3D Pseudo-Loglikelihood Estimation
#'
#' @format A numeric vector of length \eqn{(2+M)} where:
#' \describe{
#'   \item{omega}{Baseline autoregressive coefficient.}
#'   \item{alpha}{Parameter controlling variance.}
#'   \item{gamma1, gamma2, gamma3}{Coefficients related to external factors.}
#' }
#'
"init_params_full"

#' list containing Chatham-Kent, Lambton, and Wellington
#'
"medoid_names"

#' 54
#'
"n_train"

#' 19
#'
"n_test"

#' 1950-2003
#'
"time_train"

#' 2004-2022
#'
"time_test"

#' 1950-2022
#'
"time"

#' Pseudo-Observations of BSTS Residuals for Crop Yield Forecasting
#'
#' @format A matrix with dimensions \eqn{(n_train, D)}:
#' \describe{
#'   \item{n_train}{Number of time points used in the training set.}
#'   \item{D}{Number of regions analyzed (\code{Chatham-Kent}, \code{Lambton},\code{Wellington}).}
#' }
#'
#' @source Derived from residuals of BSTS models fitted to crop yield data.
#'
"u"

#' Crop Yield Data for Testing in BSTS Models
#'
#' @format A matrix with dimensions \eqn{(n_test, D)}:
#' \describe{
#'   \item{n_train}{Number of time points used in the test set.}
#'   \item{D}{Number of regions analyzed (\code{Chatham-Kent}, \code{Lambton},\code{Wellington}).}
#' }
#'
#' @source Historical crop yield records from ClimateData.ca.
#'
"y_test"

#' Crop Yield Training Matrix
#'
#' Training crop-yield data used for BSTS models.
#'
#' @format A numeric matrix with \code{n_train} rows and \code{D} columns:
#' \describe{
#'   \item{rows (\code{n_train})}{Number of time points in the training set.}
#'   \item{columns (\code{D})}{Regions analyzed (\code{Chatham-Kent}, \code{Lambton}, \code{Wellington}).}
#' }
#' @source ClimateData.ca (processed)
#' @keywords datasets
"y_train"

#' Standardized Covariates (Training)
#'
#' Standardized climate covariates used to fit the BSTS models (training).
#'
#' @format A numeric array with dimensions \code{n_train × D × M}:
#' \describe{
#'   \item{\code{n_train}}{Number of training time points.}
#'   \item{\code{D}}{Regions (\code{Chatham-Kent}, \code{Lambton}, \code{Wellington}).}
#'   \item{\code{M}}{Number of covariates (\code{cddcold}, \code{tr18}, \code{txgt27}, \code{tnmean}, \code{txgt29}).}
#' }
#' @source ClimateData.ca (processed)
#' @keywords datasets
"z_train"

#' Standardized Covariates (Test)
#'
#' Standardized climate covariates used to forecast with the BSTS models (test).
#'
#' @format A numeric array with dimensions \code{n_test × D × M}:
#' \describe{
#'   \item{\code{n_test}}{Number of test time points.}
#'   \item{\code{D}}{Regions (\code{Chatham-Kent}, \code{Lambton}, \code{Wellington}).}
#'   \item{\code{M}}{Number of covariates (\code{cddcold}, \code{tr18}, \code{txgt27}, \code{tnmean}, \code{txgt29}).}
#' }
#' @source ClimateData.ca (processed)
#' @keywords datasets
"z_test"
