test_that("log_likelihood_noGEV_3d returns numeric", {
  skip_if_not_installed("copula")
  set.seed(3)
  n <- 12; M <- 2
  u1 <- pnorm(rnorm(n)); u2 <- pnorm(rnorm(n)); u3 <- pnorm(rnorm(n))
  X  <- matrix(rnorm(n * M), ncol = M)
  z1 <- matrix(rnorm(n * M), ncol = M)
  z2 <- matrix(rnorm(n * M), ncol = M)
  z3 <- matrix(rnorm(n * M), ncol = M)
  params <- c(0, 0.4, rep(0.1, M))
  val <- STCYP::log_likelihood_noGEV_3d(params, u1, u2, u3, X, z1, z2, z3, "Gaussian")
  expect_type(val, "double")
  expect_true(is.finite(val))
})
