% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TGSTFunctions.R
\name{nonpar.rules}
\alias{nonpar.rules}
\title{Nonparametric Rules Set}
\usage{
nonpar.rules(Z, S, phi)
}
\arguments{
\item{Z}{True disease status (No disease / treatment success coded as Z=0, diseased / treatment failure coded as Z=1).}

\item{S}{Risk score.}

\item{phi}{Percentage of patients taking viral load test.}
}
\value{
Matrix with 2 columns. Each row is a possible tripartite rule, with output on lower and upper cutoff.
}
\description{
This function gives you all possible cutoffs \eqn{[l,u]} for tripartite rules, by applying nonparametric search to the given data. 
\deqn{P(S in [l,u]) \le \phi}
}
\examples{
d = Simdata
Z = d$Z # True Disease Status
S = d$S # Risk Score
phi = 0.1 #10\% of patients taking viral load test
nonpar.rules( Z, S, phi)
}
\keyword{nonparametric}
\keyword{rules}
