% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clarAdj.R
\name{clarAdj}
\alias{clarAdj}
\title{Adjusted Cumulative LGD Accuracy Ratio}
\usage{
clarAdj(y, hx)
}
\arguments{
\item{y}{a vector of realized categories.}

\item{hx}{a vector of predicted categories.}
}
\value{
The function returns the adjusted CLAR for a vector of realized categories \code{y} and a vector of predicted categories \code{hx}.
}
\description{
Calculates for a vector of realized categories \code{y} and a vector of predicted categories \code{hx} the cumulative LGD accuarcy ratio (CLAR) according to Ozdemir and Miu (2009) and adjusts it such that the measure has a value of zero if the two ordinal rankings are in reverse order.
}
\examples{
clarAdj(rep(1:5,each=3),c(3,3,3,rep(2:5,each=3)))
}
\references{
Ozdemir, B., Miu, P., 2009. Basel II Implementation. A Guide to Developing and Validating a Compliant Internal Risk Rating System. McGraw-Hill, USA.
}
