% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{computeX2M1X2}
\alias{computeX2M1X2}
\title{Internal function: Computes X2M1X2 for walsNB when SVD is applied to Z1}
\usage{
computeX2M1X2(
  X2,
  X2start,
  qStart,
  U,
  UellStart,
  ellStart,
  psiStart,
  gStart,
  epsilonStart,
  geB
)
}
\arguments{
\item{X2}{Design matrix for auxiliary regressors}

\item{X2start}{Transformed design matrix for auxiliary regressors. Refers to
\eqn{\bar{X}_{2} = \bar{\Psi}^{1/2} X_{2}}.}

\item{qStart}{Vector \eqn{\bar{q}}, see section "One-step ML estimator" of
\insertCite{huynhwalsnb;textual}{WALS} for definition.}

\item{U}{\eqn{U} of SVD of \eqn{Z_1}. See details.}

\item{UellStart}{Vector \eqn{U \bar{\ell}}, see details.}

\item{ellStart}{Vector \eqn{\bar{\ell}} see details.}

\item{psiStart}{Diagonal matrix \eqn{\bar{\Psi}}, see section
"One-step ML estimator" of \insertCite{huynhwalsnb;textual}{WALS} for definition.}

\item{gStart}{Derivative of dispersion parameter \eqn{\rho} of NB2 with
respect to \eqn{\alpha = \log(\rho)} evaluated at starting values of
one-step ML. \code{gStart} is a scalar.
See section "ML estimation" of  \insertCite{huynhwalsnb;textual}{WALS}.}

\item{epsilonStart}{Scalar \eqn{\bar{\epsilon}}, see section
"One-step ML estimator" of \insertCite{huynhwalsnb;textual}{WALS} for definition.}

\item{geB}{\eqn{\bar{g} \bar{\epsilon} / (1 + B)}. In code
\code{gStart*epsilonStart / (1+B)}. See details for definition of \eqn{B}.
\code{gStart} is \eqn{\bar{g}} and \code{epsilonStart} is \eqn{\bar{\epsilon}}.}
}
\description{
Exploits the SVD of \eqn{\bar{Z}_1} to compute
\eqn{\bar{X}_{2}^{\top} \bar{M}_{1} \bar{X}_{2}} to avoid directly inverting
\eqn{\bar{Z}_{1}^{\top} \bar{Z}_{1}}.
}
\details{
See section
"Simplification for computing \eqn{\bar{X}_{2}^{\top} \bar{M}_{1} \bar{X}_{2}}"
in the appendix of \insertCite{huynhwals;textual}{WALS} for details of the
implementation and for the definitions of arguments \code{Uellstart},
\code{ellStart}, and \code{geB}.

All parameters that contain "start" feature the starting values for the
one-step ML estimation of submodels. See section "One-step ML estimator" of
\insertCite{huynhwalsnb;textual}{WALS} for details.
}
\references{
\insertAllCited{}
}
