\name{summaryTxTablePrint}
\alias{summaryTxTablePrint}
\title{Prints a transaction summary table generated by summaryTxDataFrameCreate 
}
\description{
Formats and prints the \LaTeX for a transaction summary table as generated by \code{\link{summaryTxDataFrameCreate}}.

The first column in the table is assumed to be a URL and is 0.6 times the width of the text page, subsequent column are formatted left or right aligned as appropriate for numeric or character variables.  
}
\usage{
summaryTxTablePrint(dataFrame, formatFunctions=NULL) }
\arguments{
  \item{dataFrame}{
	transaction summary data frame generated by \code{\link{summaryTxDataFrameCreate}}
	}
  \item{formatFunctions}{
	a list of formatting functions that accept a value and return a formatted value.  The sample report includes functions f0, f2 that format numbers with 0 or 2 respectively decimal places.   
	}
}
\value{
Does not return a value.  It prints the xtable.  
}
\author{
Greg Hunt <greg@firmansyah.com>
}
\examples{
\dontshow{
datd = paste0(tempdir(),"/minconfigtemp")
unlink(datd)
dir.create(paste0(tempdir(),"/minconfigtemp"))
logfile = paste0(datd,"/log.log")
fileConn = gzfile(system.file("extdata", "compressed.log", package = "WebAnalytics"))
writeLines(readLines(fileConn,n=100),con=logfile)
close(fileConn)
# set the files directory name suitable for an R example
configVariableSet("config.workdir", tempdir())
setDTthreads(threads=1)
}
f0<-function(n)
{
	return(format(n,digits=1,nsmall=0,big.mark=","))
}
f2<-function(n)
{
	return(format(n,digits=2,nsmall=2,big.mark=","))
}
logFileName = logFileNamesGetLast(dataDirectory=datd, 
  directoryNames=c(".", "."), 
  fileNamePattern="*[.]log")[[1]]

cols = logFileFieldsGetIIS(logFileName)

logdf = logFileRead(logFileName, columnList=cols, 
            logTimeZone = "", timeFormat = "")

summarydf = summaryTxDataFrameCreate(logdf)

summaryTxTablePrint(summarydf[1:40,c(2,1,4,3)],list(format, f2, f2, f0))

}
\keyword{ manip }
