% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/afmHysteresis.R
\name{afmHysteresis}
\alias{afmHysteresis}
\title{Hysteresis}
\usage{
afmHysteresis(afmdata, silent = FALSE,...)
}
\arguments{
\item{afmdata}{A Force-Distance curve with the afmdata structure. It should be a list
with at least the 'data' field with a data frame of at least 4 columns.}

\item{silent}{Logical value. If TRUE omits the name of curve being processed (defaults to FALSE)}

\item{...}{Extra options to be passed to \code{afmZeroPointSlope} function}
}
\value{
An \code{afmdata} class variable which will consist on the original input
  \code{afmdata} variable plus a new list named \code{Hysteresis} with the following fields:
  
\code{Hyst_app} Time hyst app

\code{Hyst_ret} Time hyst ret

\code{Hyst_tot} Time hyst total 

\code{Hyst_ratio} Time hyst app/ret ratio
}
\description{
Bla bla bal
}
\examples{
path <- path.package("afmToolkit")
data <- afmReadJPK("force-save-JPK-3h.txt.gz", path = path)
width <- 20
mul1 <- 1
mul2 <- 10
data <- afmContactPoint(data, width = width, mul1 = mul1, mul2 = mul2)
\dontrun{
plot(data, segment = "approach") + geom_vline(xintercept = data$CP$CP, lty = 2)
}
}
\seealso{
\code{\link{afmZeroPointSlope}}
}
