% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{AMS}
\alias{AMS}
\title{AMS
Adaptive Multilevel Splitting estimator for rare-event option payoffs.}
\usage{
AMS(
  model,
  type,
  funz,
  n,
  t,
  p,
  r,
  sigma,
  S0,
  rho = NULL,
  rim = 0L,
  v0 = 0.04,
  Lmax = 0,
  strike = 1,
  K = 1L
)
}
\arguments{
\item{model}{1 = Black–Scholes; 2,3,4 = Heston variants (as in \code{simulate_AMS}).}

\item{type}{Payoff type passed to \code{payoff()} and \code{function_AMS_Cpp} (1..6).}

\item{funz}{1 = BS digital proxy in continuation; 2 = raw feature (signed).}

\item{n}{Population size (> K).}

\item{t}{Maturity in years (>0).}

\item{p}{Total time steps (>0).}

\item{r}{Risk–free rate.}

\item{sigma}{BS volatility (used by continuation; >0 if \code{funz == 1}).}

\item{S0}{Initial spot.}

\item{rho}{Correlation for Heston models (required for \code{model >= 2}, in \eqn{[-1,1]}).}

\item{rim}{Left-trim for simulation (keep last \code{p - rim} steps; \code{0 <= rim < p}).}

\item{v0}{Initial variance for Heston models (>=0).}

\item{Lmax}{Stopping level: iterate while \eqn{L < L_{\max}}.}

\item{strike}{Strike \eqn{K} used by continuation and final payoff.}

\item{K}{Number of resampled offspring per iteration (1..n-1).}
}
\value{
List with \code{price} and \code{std}.
}
\description{
Pipeline per iteration:
\itemize{
\item Simulate \eqn{n} paths under the chosen model (BS/Heston-family).
\item Compute continuation scores \eqn{a_{i,j}} via \code{function_AMS_Cpp}.
\item Set level \eqn{L =} K-th order statistic of \eqn{\max_j a_{i,j}}.
\item Identify survivors (top \eqn{n-K}) and parents (\eqn{K} indices that cleared the level).
\item For each parent, cut at first index that exceeds \eqn{L} and resimulate the suffix.
\item Repeat until \eqn{L \ge L_{\max}}. Then compute discounted payoff on the final population.
}
}
\examples{
\donttest{
  out <- AMS(model = 2, type = 3, funz = 1, n = 500, t = 1, p = 252, r = 0.03,
             sigma = 0.2, rho = -0.5, S0 = 1, rim = 0, Lmax = 0.5, strike = 1.3, K = 200)
  str(out)
}
}
