% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powerfx.r
\name{powerfx}
\alias{powerfx}
\title{Function to computes the power model, as a
classical allometric functional form.}
\usage{
powerfx(x = x, paramod = paramod, phi = 0)
}
\arguments{
\item{x}{is the predictor variable.}

\item{paramod}{is a vector having the  coefficients
of the model in the following order:
\eqn{\alpha,\beta}.}

\item{phi}{is an optional constant term that force the prediction
of \emph{y} when \emph{x=0}. Thus, the model becomes
\eqn{ y_i = \phi+ \alpha x_i^{\beta} }. The default
value is 0.}
}
\value{
Returns the response variable based upon
the predictor variable and the coefficients.
}
\description{
Function of the power model, based
upon the model parameters, and a single predictor variable as
follows
\deqn{ y_i = \alpha x_i^{\beta} }
where: \eqn{y_i} and \eqn{x_i} are the response
and predictor variable, respectively for the \emph{i}-th observation;
and the rest are parameters (i.e., coefficients).
}
\examples{
# Parameters
alpha<- 2.86; beta<- 0.49;
coefs<-c(alpha,beta);
# Predictor variable to be used is 30 
# Using the function
powerfx(x=30,paramod=coefs)
 
}
\references{
Salas-Eljatib C. 2025. Funciones matematicas y
sus reparametrizaciones para la alometria de arboles. Documento
de trabajo No. 1, Serie: Cuadernos de biometria,
Laboratorio de Biometria y Modelacion Forestal, Universidad
de Chile. Santiago, Chile. 52 p.
}
\author{
Christian Salas-Eljatib.
}
