% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers-data.R
\name{standata.bmmformula}
\alias{standata.bmmformula}
\alias{standata}
\title{Stan data for \code{bmm} models}
\usage{
\method{standata}{bmmformula}(object, data, model, ...)
}
\arguments{
\item{object}{A \code{bmmformula} object}

\item{data}{An object of class data.frame, containing data of all variables
used in the model. The names of the variables must match the variable names
passed to the \code{bmmodel} object for required argurments.}

\item{model}{A description of the model to be fitted. This is a call to a
\code{bmmodel} such as \code{mixture3p()} function. Every model function has a
number of required arguments which need to be specified within the function
call. Call \code{\link[=supported_models]{supported_models()}} to see the list of supported models and
their required arguments}

\item{...}{Further arguments passed to \code{\link[brms:standata]{brms::standata()}}. See the
description of \code{\link[brms:standata]{brms::standata()}} for more details}
}
\value{
A named list of objects containing the required data to fit a bmm
model with Stan.
}
\description{
Given the \code{model}, the \code{data} and the \code{formula} for the model,
this function will return the combined stan data generated by \code{bmm} and
\code{brms}
}
\examples{
sdata1 <- standata(bmf(c ~ 1, kappa ~ 1),
  data = oberauer_lin_2017,
  model = sdm(resp_error = "dev_rad")
)
str(sdata1)
}
\seealso{
\code{\link[=supported_models]{supported_models()}}, \code{\link[brms:standata]{brms::standata()}}
}
\keyword{extract_info}
