% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/number_series.R
\name{number_series}
\alias{number_series}
\alias{bernoulli_b2n}
\alias{max_bernoulli_b2n}
\alias{unchecked_bernoulli_b2n}
\alias{tangent_t2n}
\alias{prime}
\alias{max_prime}
\alias{fibonacci}
\alias{unchecked_fibonacci}
\title{Number Series}
\usage{
bernoulli_b2n(n = NULL, start_index = NULL, number_of_bernoullis_b2n = NULL)

max_bernoulli_b2n()

unchecked_bernoulli_b2n(n)

tangent_t2n(n = NULL, start_index = NULL, number_of_tangent_t2n = NULL)

prime(n)

max_prime()

fibonacci(n)

unchecked_fibonacci(n)
}
\arguments{
\item{n}{Index of number to compute (must be a non-negative integer)}

\item{start_index}{The starting index for the range of numbers (must be a non-negative integer)}

\item{number_of_bernoullis_b2n}{The number of Bernoulli numbers to compute}

\item{number_of_tangent_t2n}{The number of tangent numbers to compute}
}
\value{
A single numeric value for the Bernoulli numbers, tangent numbers, fibonacci numbers, or prime numbers, or a vector of values for ranges.
}
\description{
Functions to compute Bernoulli numbers, tangent numbers, fibonacci numbers, and prime numbers.
}
\details{
Efficient computation of Bernoulli numbers, tangent numbers, fibonacci numbers, and prime numbers.

The \code{checked_} functions ensure that the input is within valid bounds, while the \code{unchecked_} functions do not perform such checks,
allowing for potentially faster computation at the risk of overflow or invalid input.

The \code{max_} functions return the maximum index for which the respective numbers can be computed using precomputed lookup tables.
}
\examples{
bernoulli_b2n(10)
max_bernoulli_b2n()
unchecked_bernoulli_b2n(10)
bernoulli_b2n(start_index = 0, number_of_bernoullis_b2n = 10)
tangent_t2n(10)
tangent_t2n(start_index = 0, number_of_tangent_t2n = 10)
prime(10)
max_prime()
fibonacci(10)
unchecked_fibonacci(10)
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/number_series.html}{Boost Documentation} for more details on the mathematical background.
}
