% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10_modifiedCallButterflyGraph.R
\name{modifiedCallButterfly}
\alias{modifiedCallButterfly}
\title{Calculates Profit and Loss (PnL) per share (or unit of the underlying) at expiration and Breakeven (BE) point for Modified Call Butterfly and draws its graph in the Plots tab.}
\usage{
modifiedCallButterfly(
  ST,
  X1L,
  X2M,
  X3H,
  CX1L,
  CX2M,
  CX3H,
  hl = 0.8,
  hu = 1.3,
  xlab = "Spot Price ($) at Expiration",
  ylab = " Profit / Loss [ PnL ] at Expiration ($)",
  main = "Modified Call Butterfly ",
  sub = "bullishTrader / MaheshP Kumar"
)
}
\arguments{
\item{ST}{Spot Price at time T.}

\item{X1L}{Lower Strike Price or eXercise price.}

\item{X2M}{Medium Strike Price or eXercise price.}

\item{X3H}{Higher Strike Price or eXercise price.}

\item{CX1L}{Call Premium Paid for the bought Call at Lower Strike.}

\item{CX2M}{Call Premium received from the sold Call at Medium Strike.}

\item{CX3H}{Call Premium paid for the bought Call at higher Strike .}

\item{hl}{lower bound value for setting lower limit of X axis displaying spot price.}

\item{hu}{upper bound value for setting upper limit of X axis displaying spot price.}

\item{xlab}{X axis label.}

\item{ylab}{Y axis label.}

\item{main}{Title of the Graph.}

\item{sub}{Subtitle of the Graph.}
}
\value{
Returns a graph Modified Call Butterfly.
}
\description{
This is a variation of the long call butterfly strategy and the strikes are no longer equidistant; instead we have X3H minus X2M is less than X2M minus X1L. This results in a sideways strategy with a bullish bias (Kakushadze & Serur, 2018).
}
\details{
According to conceptual details given by Cohen (2015), and a closed form solution provided by Kakushadze and Serur (2018), this method is developed, and the given examples are created, to compute per share Profit and Loss and Breakeven (BE) point at expiration for Modified Call Butterfly and draw its graph in the Plots tab.
}
\examples{
modifiedCallButterfly(50,45,55,60,6.12,1.30,0.50)
modifiedCallButterfly(1000,980,1020,1030,60,20,7,hl=0.97,hu=1.05)
}
\references{
Cohen, G. (2015). The Bible of Options Strategies (2nd ed.). Pearson Technology Group.\cr
Kakushadze, Z., & Serur, J. A. (2018, August 17). 151 Trading Strategies. Palgrave Macmillan. https://papers.ssrn.com/sol3/papers.cfm?abstract_id=3247865

Cohen, G. (2015). The Bible of Options Strategies (2nd ed.). Pearson Technology Group. https://bookshelf.vitalsource.com/books/9780133964448\cr
Kakushadze, Z., & Serur, J. A. (2018, August 17). 151 Trading Strategies. Palgrave Macmillan. https://papers.ssrn.com/sol3/papers.cfm?abstract_id=3247865
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
