% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iso.R
\name{iso_date}
\alias{iso_date}
\alias{as_iso}
\title{ISO calendar dates}
\usage{
iso_date(year = integer(), week = integer(), day = integer())

as_iso(date)
}
\arguments{
\item{year}{A numeric vector of years}

\item{week}{A numeric vector of weeks}

\item{day}{A numeric vector of days}

\item{date}{Vector of dates on some calendar}
}
\value{
An iso vector object
}
\description{
In ISO 8601 date objects, weeks are defined as starting on Mondays. Week 1
is the first week with at least 4 days in the year. Equivalently, it is the week
containing 4 January. There is no week 0; instead week 1 of a year may begin in
the previous calendar year.
}
\details{
More flexible week numbering is possible using Gregorian dates with \code{\link{week_of_year}()}.
}
\examples{
iso <- new_date(year = 2025, week = 23, day = 2:4, calendar = cal_iso)
iso
iso_date(2025, 23, 2:4)
as_gregorian(iso_date(2025, 23, 2:4))
as_iso(gregorian_date(2025, 1, 1:31))
as_iso("2016-01-01")
as_iso(Sys.Date())
tibble::tibble(
  x = seq(as.Date("2025-01-01"), as.Date("2025-12-31"), by = "day"),
  y = as_iso(x)
)
}
\seealso{
\link{cal_iso}, \link{week_of_year}
}
