% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dotDensityLayer.R
\name{dotDensityLayer}
\alias{dotDensityLayer}
\title{Dot Density Layer}
\usage{
dotDensityLayer(
  x,
  spdf,
  df,
  spdfid = NULL,
  dfid = NULL,
  var,
  n = NULL,
  pch = 1,
  cex = 0.15,
  type = "random",
  col = "black",
  legend.pos = "topright",
  legend.txt = NULL,
  legend.cex = 0.6,
  legend.col = "black",
  legend.frame = TRUE,
  add = TRUE
)
}
\arguments{
\item{x}{an sf object, a simple feature collection. If x is used then spdf,
df, spdfid and dfid are not.}

\item{spdf}{a SpatialPolygonsDataFrame.}

\item{df}{a data frame that contains the values to plot. If df is missing 
spdf@data is used instead.}

\item{spdfid}{name of the identifier variable in spdf, default to the first 
column of the spdf data frame. (optional)}

\item{dfid}{name of the identifier variable in df, default to the first 
column of df. (optional)}

\item{var}{name of the numeric variable to plot.}

\item{n}{one dot on the map represents n (in var units).}

\item{pch}{symbol to use: \link{points}.}

\item{cex}{size of the symbols}

\item{type}{points allocation method: "random" or "regular" (see Details).}

\item{col}{color of the points.}

\item{legend.pos}{"topright", "left", "right", "bottomleft", "bottom", "bottomright". If 
legend.pos is "n" then the legend is not plotted.}

\item{legend.txt}{text in the legend.}

\item{legend.cex}{size of the legend text.}

\item{legend.col}{color of the text in the legend.}

\item{legend.frame}{whether to add a frame to the legend (TRUE) or 
not (FALSE).}

\item{add}{whether to add the layer to an existing plot (TRUE) or 
not (FALSE).}
}
\description{
Plot a dot density layer.
}
\details{
The type parameters is defined within the \link[sf]{st_sample} function.
}
\examples{
\dontrun{
library(sf)
mtq <- st_read(system.file("gpkg/mtq.gpkg", package="cartography"))
plot(st_geometry(mtq), col = "#B8704D50")
dotDensityLayer(x = mtq,  var="POP", pch=20, col = "red4", n = 200)
layoutLayer(title = "Population Distribution in Martinique, 2015")
}
}
\seealso{
\link{propSymbolsLayer}
}
