% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_dynamics}
\alias{plot_dynamics}
\title{Plot Dynamics with Optional Stress Shading}
\usage{
plot_dynamics(
  S,
  stress_windows = NULL,
  title = "Dynamics",
  colors = NULL,
  legend_labels = NULL,
  show_lines = FALSE,
  line_width = 0.8,
  line_alpha = 1,
  base_size = 14,
  label_stress = TRUE,
  stress_label = "Stress Period",
  stress_fill = "gray60",
  stress_alpha = 0.2,
  stress_line_color = "gray40",
  y_label = "Level",
  legend_position = "right",
  y_limits = NULL
)
}
\arguments{
\item{S}{Matrix (time x variables) of simulated states. If \code{attr(S,"time")}
exists, it is used for the x-axis (continuous time). Otherwise the x-axis
is step index \code{1:nrow(S)}.}

\item{stress_windows}{Optional list of numeric \code{c(start, end)} intervals,
or a 2-column matrix/data.frame with \code{start,end}. Units must match the
x-axis (i.e., the "Time" used for plotting).}

\item{title}{Plot title.}

\item{colors}{Optional vector of line colors (length = #variables).}

\item{legend_labels}{Optional vector of legend labels (length = #variables).}

\item{show_lines}{If TRUE, draw dashed vertical lines instead of shaded rectangles.}

\item{line_width}{Line width for trajectories.}

\item{line_alpha}{Line transparency (0–1).}

\item{base_size}{Base font size for theme.}

\item{label_stress}{If TRUE and using shading, label each stress window.}

\item{stress_label}{Text label (length 1 or length = #windows).}

\item{stress_fill}{Fill color for shaded windows.}

\item{stress_alpha}{Alpha for shaded windows.}

\item{stress_line_color}{Color for dashed lines (if \code{show_lines = TRUE}).}

\item{y_label}{Y-axis label.}

\item{legend_position}{Legend position (e.g., \code{"right"}, \code{"bottom"}, \code{"none"}).}

\item{y_limits}{Optional numeric length-2 vector for y-axis limits.}
}
\value{
A ggplot object.
}
\description{
Visualizes node/variable dynamics over time using ggplot2, with optional
stress intervals and customizable styling.
}
