% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clock_chart_col.R
\name{clock_chart_col}
\alias{clock_chart_col}
\title{Clock Chart, Hands Colored by a Numeric Variable}
\usage{
clock_chart_col(data, time, crit, high = "red", low = "green")
}
\arguments{
\item{data}{A data frame}

\item{time}{Time in 24 hours. The allowed time formats for these family
of charts are \code{HH:MM:SS}, \code{HH:MM} or even \code{H:M} (such as \verb{12;30:09}
or \code{9:3}).}

\item{crit}{a numeric vector by which lines will be colored.}

\item{high}{The color name for the high values. The default is \code{red}}

\item{low}{The color name for the low values. The default is \code{green}.
The color names can be vice versa or other colors, depending on the context.}
}
\value{
A \code{ggplot} object, which can be further modified
with \code{ggplot2} functions and themes.
}
\description{
This function will plot time of events on a 24 hour clock to show which
events took place at what times. The lines are colored by a criteria.
}
\details{
Change the title, subtitle or the caption of the plot with
\code{ggplot2::labs()} .Change the legend title by adding
\code{ggplot2::labs(size = "TITLE")} or \code{labs(color = "TITLE")}.

Add
or modify legend by \code{theme(legend.position = "POSITION")}; the valid
position names in \code{ggplot2} are \code{top}, \code{bottom}, \code{right}, and \code{left},
excluding more complex options.
}
\examples{
df <- data.frame(
  time = c("06:00:00", "08:00:00", "17:30:00"),
  value = c(3, 6, 9)
)
clock_chart_col(df, time, crit = value) +
  ggplot2::labs(size = "TITLE")

}
\seealso{
\code{\link[=clock_chart_qnt]{clock_chart_qnt()}}, and \code{\link[=clock_chart_qlt]{clock_chart_qlt()}}.
}
