% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kregcurves.R
\name{kregcurves}
\alias{kregcurves}
\title{k-groups of multiple regression curves}
\usage{
kregcurves(y, x, z, k, kbin = 50, h = -1, algorithm = "kmeans", seed = NULL)
}
\arguments{
\item{y}{Response variable.}

\item{x}{Dependent variable.}

\item{z}{Categorical variable indicating the population to which
the observations belongs.}

\item{k}{An integer specifying the number of groups of curves to be
performed.}

\item{kbin}{Size of the grid over which the survival functions
are to be estimated.}

\item{h}{The kernel bandwidth smoothing parameter.}

\item{algorithm}{A character string specifying which clustering algorithm is used,
i.e., k-means(\code{"kmeans"}) or k-medians (\code{"kmedians"}).}

\item{seed}{Seed to be used in the procedure.}
}
\value{
A list containing the following items:
\item{measure}{Value of the test statistic.}
 \item{levels}{Original levels of the variable \code{fac}.}
 \item{cluster}{A vector of integers (from 1:k) indicating the cluster to
 which each curve is allocated.}
 \item{centers}{An object containing the fitted centroids
 (mean of the curves pertaining to the same group).}
 \item{curves}{An object containing the fitted regression
 curves for each population.}
}
\description{
Function for grouping regression curves, given a number k,
based on the k-means or k-medians algorithm.
}
\examples{
library(clustcurv)

# Regression: 2 groups k-means
r2 <- kregcurves(y = barnacle5$DW, x = barnacle5$RC,
z = barnacle5$F, k = 2, algorithm = "kmeans")

data.frame(level = r2$level, cluster = r2$cluster)



}
\author{
Nora M. Villanueva and Marta Sestelo.
}
