% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{product}
\alias{product}
\title{Product Data from the Contonso Dataset}
\format{
A data frame with 14 columns:
\describe{
\item{product_key}{\code{double} Unique identifier for each product.}
\item{product_code}{\code{character} A code that uniquely identifies the product.}
\item{product_name}{\code{character} The name or description of the product.}
\item{manufacturer}{\code{character} The name of the manufacturer of the product.}
\item{brand}{\code{character} The brand of the product.}
\item{color}{\code{character} The color of the product.}
\item{weight_unit}{\code{character} The unit of measurement for the product's weight (e.g., "kg", "lbs").}
\item{weight}{\code{double} The weight of the product.}
\item{cost}{\code{double} The cost price of the product.}
\item{price}{\code{double} The selling price of the product.}
\item{category_key}{\code{double} Unique identifier for the category to which the product belongs.}
\item{category_name}{\code{character} The name of the category to which the product belongs.}
\item{sub_category_key}{\code{double} Unique identifier for the subcategory to which the product belongs.}
\item{sub_category_name}{\code{character} The name of the subcategory to which the product belongs.}
}
}
\source{
https://github.com/sql-bi/Contoso-Data-Generator-V2-Data/releases/tag/ready-to-use-data
}
\usage{
product
}
\description{
This dataset contains information about products in the Contonso dataset. It includes product details such as identifiers,
descriptions, pricing, weight, and categorization. This dataset is useful for analyzing product characteristics, pricing, and
product-related sales insights.
}
\keyword{datasets}
