% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{visualize_factor_dynamics}
\alias{visualize_factor_dynamics}
\title{Visualize factor dynamics comprehensively}
\usage{
visualize_factor_dynamics(
  dfm_result,
  ou_result,
  factors_data,
  save_plot = FALSE,
  plot_file = NULL,
  use_device = "default",
  verbose = TRUE
)
}
\arguments{
\item{dfm_result}{Result object from DFM analysis}

\item{ou_result}{Result object from OU estimation}

\item{factors_data}{Data frame with factor information}

\item{save_plot}{Logical, save plot to file (default: FALSE)}

\item{plot_file}{File name for saved plot (default: 'factor_dynamics.pdf')}

\item{use_device}{Graphics device to use: 'default', 'pdf', 'png' (default: 'default')}

\item{verbose}{Logical; print progress and diagnostic information. Default \code{TRUE}.}
}
\value{
Invisibly returns \code{NULL}. Called for side effect of creating plots.
}
\description{
Creates a multi-panel visualization summarizing all aspects of the factor
model: scores over time, loadings, correlations, OU dynamics, and convergence
patterns.
}
\details{
Default is \code{NULL} (display only).
}
