% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivarsusie.R
\name{cophe.susie.lbf}
\alias{cophe.susie.lbf}
\title{cophe.susie.lbf}
\usage{
cophe.susie.lbf(
  dataset,
  querysnpid,
  querytrait,
  switch = TRUE,
  susie.args = list(),
  MAF = NULL
)
}
\arguments{
\item{dataset}{a list with specifically named elements defining the query trait dataset
to be analysed.}

\item{querysnpid}{Id of the query variant, (id in dataset$snp)}

\item{querytrait}{Query trait name}

\item{switch}{Set switch=TRUE to obtain single BF when credible sets not found with SuSIE}

\item{susie.args}{a named list of additional arguments to be passed to
\link[coloc]{runsusie}}

\item{MAF}{Minor allele frequency vector}
}
\value{
data frame with log bayes factors for Hn and Ha hypotheses
}
\description{
Calculate log bayes factors for each hypothesis (SuSIE - multiple causal variant assumption)
}
\examples{
library(cophescan)
data(cophe_multi_trait_data)
query_trait_1 <- cophe_multi_trait_data$summ_stat[['Trait_1']]
query_trait_1$LD <- cophe_multi_trait_data$LD
querysnpid <- cophe_multi_trait_data$querysnpid
res.susie.lbf <- cophe.susie.lbf(query_trait_1, querysnpid = querysnpid,
                                  querytrait='Trait_1', switch=T)
res.susie.lbf
}
\seealso{
\code{\link{cophe.susie}}
}
\author{
Ichcha Manipur
}
