% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_batch.R
\name{calc_batch}
\alias{calc_batch}
\alias{calc_emissions_batch}
\title{Batch carbon footprint calculation}
\usage{
calc_batch(
  data,
  tier = 2,
  boundaries = set_system_boundaries("farm_gate"),
  benchmark_region = NULL,
  save_detailed_objects = FALSE
)
}
\arguments{
\item{data}{A data.frame with one row per farm (already loaded). This version does not read files.}

\item{tier}{Integer; methodology tier (usually 1 or 2). Default = 2.}

\item{boundaries}{System boundaries as returned by \code{set_system_boundaries()}.}

\item{benchmark_region}{Optional character code/region for benchmarking (if supported).}

\item{save_detailed_objects}{Logical; if TRUE, returns detailed objects per farm.}
}
\value{
A list with \code{$summary} and \code{$farm_results}; class \code{cf_batch_complete}.
}
\description{
Processes a data.frame of farms and computes emissions per farm,
returning a summary plus per-farm details (optionally).
}
\examples{
# Minimal, fast example (Tier 1, default boundaries)
farms_min <- data.frame(FarmID = "A", Milk_litres = 1e5, Cows_milking = 50)
calc_batch(data = farms_min, tier = 1)

\donttest{
# Richer example with boundaries, benchmarking and details
farms <- data.frame(
  FarmID = c("A","B"),
  Milk_litres = c(5e5, 7e5),
  Cows_milking = c(100, 140)
)
res <- calc_batch(
  data = farms,
  tier = 2,
  boundaries = set_system_boundaries("farm_gate"),
  benchmark_region = "uruguay",
  save_detailed_objects = FALSE
)
str(res$summary)
}
}
