% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{write_h}
\alias{write_h}
\title{Write structure factors to a reflections file}
\usage{
write_h(filename, fdata)
}
\arguments{
\item{filename}{A character string. Prefix of the structure factors
file name. The file name has the form "[prefix]_h.dat".}

\item{fdata}{A names list, usually created with functions 
\code{\link{standardise_fdata}} or \code{\link{read_h}}, and consisting of
the following fields:
\itemize{
  \item{a    Real numeric. Unit cell length in angstroms. Always 
             included.}
  \item{SG.   Spacegroup 2-letters character string. There are only two 
              symmetries possible when working within 1D 
              crystallography, P1 (no symmetry) and P-1 (inversion 
              through the origin). SG can be either "P1" or "P-1". 
              Always included.}
  \item{hidx. Real numeric array. 1D unique (positive in the 1D context) 
              Miller indices. Always included.}
  \item{Fobs.      Real numeric array. Amplitudes of observed structure 
                   factors. Not always included.}
  \item{sigFobs.   Real numeric array. Errors associated with Fobs. Not 
                   always included.}
  \item{Fp.        Real numeric vector. Amplitudes of the positive 
                   component of Friedel (or Bijvoet) pairs (F+). Not
                   always included.}
  \item{sigFp.     Real numeric vector. Errors associated with Fp. 
                   Not always included.}
  \item{Fm.        Real numeric vector. Amplitudes of the negative 
                   component of Friedel (or Bijvoet) pairs (F-). Not always
                   included.}
  \item{sigFm.     Real numeric vector. Errors associated with Fm. Not
                   always included.}
  \item{Phiobs.    Real numeric array. Phases (in degrees) of structure 
                   factors obtained with one of the methods used for 
                   structure solution. Not always included.}
  \item{Phicalc.   Real numeric array. Phases (in degrees) of structure 
                   factors calculated from the correct 1D structure. 
                   They are normally used to check correctness of 
                   Phiobs. Not always included.}
        }}
}
\value{
This function does not return anything, but will create an ASCII 
 file of name *_h.dat which contains structure factors and other type of 
 information.
}
\description{
This function writes standardised structure factors data into an ASCII
file. The files includes cell size, space group character symbol and
Miller indices vector. It can include all of some of observed and/or
calculated structure factors amplitudes and phases, either for anomalous
or non-anomalous data.
}
\examples{
# Data from thiocyanate structure
datadir <- system.file("extdata",package="crone")
filename <- file.path(datadir,"thiocyanate_x.dat")
sdata <- read_x(filename)

# Miller indices
hidx <- 1:10

# Observed structure factors with errors
ltmp <- sfobs(hidx,sdata)
Fobs <- ltmp$F
sigFobs <- ltmp$sF

# Phases from calculated structure factors
ftmp <- strufac(hidx,sdata)
phicalc <- ftmp$Fpha

# Create standardised fdata structure
fdata <- standardise_fdata(sdata$a,sdata$SG,hidx,Fobs=Fobs,
                     sigFobs=sigFobs,Phicalc=phicalc)
 
# Name of structure factors file (in temporary directory)
wd <- tempdir()
fname <- file.path(wd,"test")

# Write data to file
write_h(fname,fdata)

}
