% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_silodata.R
\name{get_silodata}
\alias{get_silodata}
\title{Retrieve weather data from Queensland Government DES longpaddock website}
\usage{
get_silodata(
  latitude,
  longitude,
  email,
  START = "20201101",
  FINISH = "20201231",
  FORMAT = c("apsim", "fao56", "standard", "allmort", "ascepm", "evap_span", "span",
    "all2016", "alldata", "p51", "rainonly", "monthly", "cenw"),
  PASSWORD = "apitest",
  extras = NULL,
  URL = "https://www.longpaddock.qld.gov.au/cgi-bin/silo/DataDrillDataset.php"
)
}
\arguments{
\item{latitude}{A number or character string of the site latitude
for data retrieval}

\item{longitude}{A number or character string of the site
longitude for data retrieval}

\item{email}{A string containing your email which is required by
DES in order to access the data}

\item{START}{Start date as a character string \dQuote{YYYYMMDD}
with no spaces. Default: \dQuote{20201101}}

\item{FINISH}{Last date as a character string \dQuote{YYYYMMDD}
with no spaces. Default: \dQuote{20201231}}

\item{FORMAT}{of data file required. While this function was
originally constructed to obtain \code{apsim} format, other
formats are now available but not as tested.  \code{rainman} is
not included since it returns six separate files. See
\url{https://www.longpaddock.qld.gov.au/silo/about/file-formats-and-samples/}
Default: \dQuote{apsim}}

\item{PASSWORD}{Default: \dQuote{apitest}}

\item{extras}{A list containing variable names and values for
extra columns. Note that the new variable(s) will have the same
value. Default: \code{NULL}}

\item{URL}{is the URL for querying the website and probably will
not need to be changed. Default:
\dQuote{https://www.longpaddock.qld.gov.au/cgi-bin/silo/DataDrillDataset.php}}
}
\value{
Data frame/tibble containing specified or default climate
variables. If \dQuote{APSIM} format is specified then an extra
column \code{date_met}, containing the date, is returned along
with the usual \code{year} and day of year \code{day}.
}
\description{
SILO (Scientific Information for Land Owners) is a database of
Australian climate data from 1889 (current to yesterday). It
provides data sets for a range of climate variables. SILO is
hosted by the Science and Technology Division of the Queensland
Government's Department of Environment and Science (DES). For more
information please see
\url{https://www.longpaddock.qld.gov.au/silo/about}. A number of
data formats are available via the \code{FORMAT} option, but we
have mainly used the \dQuote{apsim} format. Other formats may be
retrieved but these are largely untested. Please lodge an issue if
there are problems. For details, please see
\url{https://www.longpaddock.qld.gov.au/silo/about/file-formats-and-samples/}.
SILO products are provided free of charge to the public for use
under the Creative Commons Attribution 4.0 license and appear to
be subject to fair use limits. Note that SILO may be unavailable
between 11am and 1pm (Brisbane time) each Wednesday and Thursday
to allow for essential system maintenance.
}
\details{
When \code{extra}is specified, then extra columns which could
for instance include the site name are added to
each row for later calculations. This can also be employed in a
loop using \code{\link[=for]{for()}} loops or a \code{tidyverse} approach, such
as \code{\link[purrrlyr:by_row]{purrrlyr::by_row()}} in order to manipulate data by site.
}
\examples{
\dontrun{
## Example 1: Replace MY_EMAIL_ADDRESS with your email address below
##            Latitude and Longitude character strings
boonah_data <-
  get_silodata(latitude = "-27.9927", longitude = "152.6906",
               email = "MY_EMAIL_ADDRESS",
               START = "20190101", FINISH = "20200531")
## Example 2: Replace MY_EMAIL_ADDRESS below with yours - adds extra column
##            Latitude and Longitude are numeric
boonah_data2 <-
  get_silodata(latitude = -27.9927, longitude = 152.6906,
               email = "MY_EMAIL_ADDRESS",
               START = "20190101", FINISH = "20200531",
               extras = list(Sitename = "Boonah"))
## Example 3: Replace MY_EMAIL_ADDRESS below with yours - adds extra column
##            Latitude and Longitude are numeric.
##            Retreives all Morton hydrological evapotranspirations
boonah_data3 <-
  get_silodata(latitude = -27.9927, longitude = 152.6906,
               email = "MY_EMAIL_ADDRESS", FORMAT  =  "allmort",
               START = "20190101", FINISH = "20190115",
               extras = list(Sitename = "Boonah"))
## Example 4: Replace MY_EMAIL_ADDRESS below with yours - adds extra column
##            Latitude and Longitude are numeric. Retreives two months of
##            total rainfall and evaporation and means for max/min
##            temperatures, solar radiation and vapour pressure
boonah_data4 <-
  get_silodata(latitude = -27.9927, longitude = 152.6906,
               email = "drpetebaker@gmail.com", FORMAT = "monthly",
               START = "20190101", FINISH = "20190228",
               extras = list(Sitename = "Boonah"))
}

}
\seealso{
\code{\link{get_multi_silodata}}
}
