% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resolve.R
\name{dc_get_dcid_by_coordinates}
\alias{dc_get_dcid_by_coordinates}
\title{Resolve DCIDs from Latitude and Longitude via Data Commons}
\usage{
dc_get_dcid_by_coordinates(
  latitude,
  longitude,
  api_key = Sys.getenv("DATACOMMONS_API_KEY"),
  base_url = Sys.getenv("DATACOMMONS_BASE_URL", unset =
    "https://api.datacommons.org/v2/"),
  return_type = "json"
)
}
\arguments{
\item{latitude}{A numeric vector of latitude values.}

\item{longitude}{A numeric vector of longitude values.}

\item{api_key}{Your Data Commons API key. If not provided, uses the
environment variable \code{DATACOMMONS_API_KEY}.}

\item{base_url}{The base URL of the Data Commons API. Defaults to the public
endpoint. For custom deployments, must end with \verb{/core/api/v2/}.}

\item{return_type}{Return format: either \code{"list"} (parsed R object) or
\code{"json"} (JSON string).}
}
\value{
A list or JSON string, depending on \code{return_type}.
}
\description{
Resolves geographic coordinates (provided as latitude and longitude) to
Data Commons DCIDs using the geoCoordinate property.
}
\examples{
\dontshow{if (dc_has_api_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get the DCID for a coordinate
dc_get_dcid_by_coordinates(37.42, -122.08)

# Batch query for multiple coordinates
dc_get_dcid_by_coordinates(c(34.05, 40.71), c(-118.25, -74.01))
\dontshow{\}) # examplesIf}
}
