% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_to_dist.R
\name{convert_to_dist}
\alias{convert_to_dist}
\title{Convert a similarity or distance matrix to a 'dist' object}
\usage{
convert_to_dist(dist_mat, similarity_transform = c("linear", "sqrt"))
}
\arguments{
\item{dist_mat}{A square matrix (similarity or distance) or a 'dist' object.}

\item{similarity_transform}{Method to convert similarity to distance. Either \code{"linear"} (default) or \code{"sqrt"}.
\itemize{
 \item{\code{"linear"}: Applies a linear transformation to convert similarity to distance.}
 \item{\code{"sqrt"}: Applies the square root transformation to convert similarity to distance.}
}}
}
\value{
An object of class 'dist'.
}
\description{
This function converts a similarity matrix (with values between 0 and 1 and 1s on the diagonal)
or a distance matrix into a 'dist' object. The user can specify the method used to transform
similarity values into distances.
}
\keyword{internal}
