% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcov.R
\name{dcov}
\alias{dcov}
\alias{dcor}
\title{Distance covariance}
\usage{
dcov(x, y, type = c("V", "U"))

dcor(x, y, type = c("V", "U"))
}
\arguments{
\item{x}{the matrix of x}

\item{y}{the matrix of y}

\item{type}{"V" or "U", for V- or U-statistics of distance covariance or
correlation. The default value is "V".}
}
\description{
This method implements the method to compute the value of distance covariance
proposed by \cite{Székely et al.(2007)} and \cite{Székely and Rizzo(2013)}
by Armadillo library. For distance covariance between two one dimensional
variables, the fast algorithm proposed by \cite{Huo and Székely(2016)} is used.
}
\note{
Note that the result of \code{dcov(x,y,"V")} and \code{dcor(x,y,"V")}
 is same with the result of energy::dcov(x,y)^2 and energy::dcor(x,y)^2.
 The result of \code{dcov(x,y,'U')} and \code{dcor(x,y,'U')} is same with
 the result of \code{energy::dcovU(x,y)} and \code{energy::bcdcor(x,y)}.
}
\examples{
x = matrix(rnorm(200),100,2)
y = matrix(rnorm(200),100,2)
dcov(x,y)
dcor(x,y)

}
\references{
Székely, G. J., Rizzo, M. L., & Bakirov, N. K. (2007). Measuring and testing dependence by correlation of distances. The annals of statistics, 35(6), 2769-2794.

Székely, G. J., & Rizzo, M. L. (2013). The distance correlation t-test of independence in high dimension. Journal of Multivariate Analysis, 117, 193-213.

Huo, X., & Székely, G. J. (2016). Fast computing for distance covariance. Technometrics, 58(4), 435-447.
}
\seealso{
dcov2d
}
