% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sources.R
\name{add_source}
\alias{add_source}
\title{Add a data source to the deckgl widget}
\usage{
add_source(deckgl, id, data)
}
\arguments{
\item{deckgl}{A deckgl widget object.}

\item{id}{The unique id of the source.}

\item{data}{The url to fetch data from or a data object.}
}
\description{
Add a data source to the deckgl widget
}
\examples{
data("bart_stations")

deckgl() \%>\%
  add_source("bart-stations", bart_stations) \%>\%
  add_scatterplot_layer(
    source = "bart-stations",
    getPosition = ~lng + lat,
    getFillColor = "steelblue",
    getRadius = 50,
    radiusScale = 6
  ) \%>\%
  add_text_layer(
    source = "bart-stations",
    getPosition = ~lng + lat,
    getText = ~name,
    getSize = 15,
    sizeScale = 1.5,
    getColor = "white"
  ) \%>\%
  add_basemap()
}
