% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NonparametricTransformation.R
\name{boot.nonparTrans}
\alias{boot.nonparTrans}
\title{Nonparametric bootstrap approach for a Semiparametric transformation model under dependent censpring}
\usage{
boot.nonparTrans(init, resData, X, W, n.boot, n.iter, eps)
}
\arguments{
\item{init}{Initial values for the finite dimensional parameters obtained from the fit of \code{\link{NonParTrans}}}

\item{resData}{Data matrix with three columns;  Z = the observed survival time, d1 = the censoring indicator of T
and  d2 =  the censoring indicator of C.}

\item{X}{Data matrix with covariates related to T}

\item{W}{Data matrix with covariates related to C.}

\item{n.boot}{Number of bootstraps to use in the estimation of bootstrap standard errors.}

\item{n.iter}{Number of iterations; the default is \code{n.iter = 15}. The larger the number of iterations, the longer the computational time.}

\item{eps}{Convergence error. This is set by the user in such away that the desired convergence is met; the default is \code{eps = 1e-3}}
}
\value{
Bootstrap standard errors for parameter estimates and for estimated cumulative hazard function.
}
\description{
This function estimates the bootstrap standard errors for the finite-dimensional model parameters and for the non-parametric transformation
function. Parallel computing using foreach has been used to speed up the estimation of standard errors.
}
