% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimize.R
\name{extract_shuffle_params}
\alias{extract_shuffle_params}
\title{Extract relevant parameters from a generic shuffle function output}
\usage{
extract_shuffle_params(shuffle, attributes_expected)
}
\arguments{
\item{shuffle}{Return value of a shuffle function}

\item{attributes_expected}{Logical; if TRUE, sample attributes are expected from the shuffling result and the
function dies if they are not provided.}
}
\value{
A list with components src, dst, location_assignment and samples_attr, depending on the output
of the specific shuffling function
}
\description{
Any shuffling function should return one of the following:
\enumerate{
\item atomic index vector for a direct location assignment
\item a list with src and dst vector
\item a list with locations vector (for location assignment) and optional sample_attr data frame/tibble
}
}
\details{
This function parses the output, performs a few checks and returns results in a simple-to-use list.
}
\keyword{internal}
