% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.dcca.R
\name{coef.dcca}
\alias{coef.dcca}
\title{Coefficients of double-constrained correspondence analysis (dc-CA)}
\usage{
\method{coef}{dcca}(
  object,
  ...,
  type = c("fourth_corner", "all_reg", "env2traits_reg", "traits2env_reg"),
  rank = "full",
  normed = TRUE
)
}
\arguments{
\item{object}{return value of \code{\link{dc_CA}}.}

\item{...}{Other arguments passed to the function (currently ignored).}

\item{type}{type of coefficients, 
\code{c("fourth_corner", "all_reg", "env2traits_reg", "traits2env_reg")} for
fourth-corner coefficients and regression coefficients for
all trait x environmental predictors, environmental predictors only 
and trait predictors only for prediction of the (transformed)
response, traits and environmental values, respectively.}

\item{rank}{rank (number of axes to use). Default "full" for all axes 
(no rank-reduction).}

\item{normed}{logical (default \code{TRUE}) giving standardized regression
coefficients and biplot scores. When \code{FALSE}, (regular)
regression coefficients and (unstandardized) biplot scores.}
}
\value{
a matrix with coefficients. The exact content of the matrix 
depends on the \code{type} of coefficient that is asked for.

Regression coefficients for a response variable 
are usually column-vectors. 
With \strong{X} the matrix of units-by-predictors
and \strong{B} the matrix of predictors-by-response-variables, 
predictions or fits are of the form \strong{Y = XB}.
Analogously, \code{type = "trait2env"} gives a trait-by-environment matrix and
\code{type = "env2traits"} gives an environment-by-trait matrix.
}
\description{
Fourth-corner coefficients and regression coefficients 
(of full or reduced rank) to predict traits from environment, 
environment from traits and response from trait and environment data.
}
\details{
Regression coefficients are for standardized traits and environmental variables.

With covariates, \code{coef()} gives partialfourth-corner correlations. 
With \code{rank = 2}, \code{coef()} gives the two-dimensional approximation
of the full-rank fourth-corner correlations in the biplot that displays the
traits and environmental variables at arrow heads or points 
at \code{scores(mod, display = c("bp", "bp_traits"))}.
}
\examples{
data("dune_trait_env")

# rownames are carried forward in results
rownames(dune_trait_env$comm) <- dune_trait_env$comm$Sites

mod <- dc_CA(formulaEnv = ~ A1 + Moist + Mag + Use + Condition(Manure),
             formulaTraits = ~ SLA + Height + LDMC + Condition(Seedmass) + Lifespan,
             response = dune_trait_env$comm[, -1],  # must delete "Sites"
             dataEnv = dune_trait_env$envir,
             dataTraits = dune_trait_env$traits,
             verbose = FALSE)

# regression coefficients
coef(mod, type = "env2traits")
coef(mod, type = "traits2env")
coef(mod, type = "fourth")
coef(mod, type = "all_reg")
}
