% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudoF.R
\name{apseudoF}
\alias{apseudoF}
\title{pseudoF (pF or Calinski-Harabsz) index for choosing k in partitioning models}
\usage{
apseudoF(data, maxK, tol, model, Q)
}
\arguments{
\item{data}{Units x variables numeric data matrix.}

\item{maxK}{Maximum number of clusters for the units to be tested.}

\item{tol}{Approximation value. It is half of the length of theinterval put for each pF. 0 <= tol < 1. Its default value is 0.05.}

\item{model}{Partitioning Models to run for each value of k. (1 = doublekm; 2 = redkm; 3 = factkm; 4 = dpcakm)}

\item{Q}{Number of principal components w.r.t. variables selected for the maxK -1 partitions to be tested.}
}
\value{
\item{bestK}{best value of K (scalar).}
}
\description{
Calculates and plots the CH index for k = 2, ..., maxK. The function provides an interval wide (2tol*pF) so that the choice of K is less conservative. Instead of just choosing the maximum pF, if it exists, picks the value such that its upper bound is larger than max pF.
}
\examples{
# Iris data 
# Loading the numeric variables of iris data
iris <- as.matrix(iris[,-5]) 

apF <- apseudoF(iris, maxK=10, tol = 0.05, model = 3, Q = 2)

}
\references{
Calinski T., Harabasz J. (1974) "A dendrite method for cluster analysis" <doi:10.1080/03610927408827101>
}
\author{
Ionel Prunila, Maurizio Vichi
}
