% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_super.R
\name{parameter}
\alias{parameter}
\alias{as.list.parameter}
\alias{as_parameter}
\alias{is_parameter}
\alias{as_descriptive_tibble}
\title{Defining, serialising and printing parameters}
\usage{
parameter(id, default, ..., description = NULL, tuneable = TRUE)

\method{as.list}{parameter}(x, ...)

as_parameter(li)

is_parameter(x)

as_descriptive_tibble(x)
}
\arguments{
\item{id}{The name of the parameter.}

\item{default}{The default value of the parameter.}

\item{...}{Extra fields to be saved in the parameter.}

\item{description}{An optional (but recommended) description of the parameter.}

\item{tuneable}{Whether or not a parameter is tuneable.}

\item{x}{An object (parameter or distribution) to be converted.}

\item{li}{A list to be converted into a parameter.}
}
\description{
Multiple parameters can be combined in a parameter set.
The sections below contain information on how to create, serialise
and process a parameter.
}
\section{Creating a parameter}{

\itemize{
\item \code{\link[=character_parameter]{character_parameter()}}, \code{\link[=integer_parameter]{integer_parameter()}}, \code{\link[=logical_parameter]{logical_parameter()}}, \code{\link[=numeric_parameter]{numeric_parameter()}}: Creating parameters with basic R data types.
\item \code{\link[=integer_range_parameter]{integer_range_parameter()}}, \code{\link[=numeric_range_parameter]{numeric_range_parameter()}}: Create a discrete or continuous range parameter.
\item \code{\link[=subset_parameter]{subset_parameter()}}: A parameter containing a subset of a set of values.
\item \code{\link[=parameter]{parameter()}}: An abstract function to be used by other parameter functions.
}
}

\section{Serialisation}{

\itemize{
\item \code{as.list(param)}: Converting a parameter to a list.
\item \code{as_parameter(li)}: Converting a list back to a parameter.
\item \code{is_parameter(x)}: Checking whether something is a parameter.
\item \code{as_descriptive_tibble(param)}: Convert to a tibble containing meta information.
}
}

\examples{
int_param <- integer_parameter(
  id = "num_iter",
  default = 100L,
  distribution = expuniform_distribution(lower = 1L, upper = 10000L),
  description = "Number of iterations"
)

print(int_param)
li <- as.list(int_param)
print(as_parameter(li))

subset_param <- subset_parameter(
  id = "dimreds",
  default = c("pca", "mds"),
  values = c("pca", "mds", "tsne", "umap", "ica"),
  description = "Which dimensionality reduction methods to apply (can be multiple)"
)

int_range_param <- integer_range_parameter(
  id = "ks",
  default = c(3L, 15L),
  lower_distribution = uniform_distribution(1L, 5L),
  upper_distribution = uniform_distribution(10L, 20L),
  description = "The numbers of clusters to be evaluated"
)

parameter_set(
  int_param,
  subset_param,
  int_range_param
)
}
\seealso{
\link{dynparam} for an overview of all dynparam functionality.
}
