% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epm_all_fx.R
\name{EPM_esearch_parse}
\alias{EPM_esearch_parse}
\title{Parse Responses from the NCBI ESearch Server.}
\usage{
EPM_esearch_parse(x)
}
\arguments{
\item{x}{String (character vector of length 1), this is the 
xml string returned by the NCBI ESearch Server.}
}
\value{
List including information extracted from the NCBI ESearch 
Server response.
}
\description{
Parse Responses from the NCBI ESearch Server and 
return a list of information that can be used for retrieving 
PubMed records from the NCBI EFetch Server.
}
\details{
The output list includes the following items.
\itemize{
  \item `web_env`. String, unique identifier for fetching PubMed records 
  corresponding to the current query.
  \item `query_key`. Integer, unique numeric key for fetching PubMed records
  corresponding to the current query.
  \item `count`. Integer, expected number of records returned 
  by the current query.
  \item `query_translation`. String, translation of the Query string 
  provided by the user.
}
}
\examples{
# Note: a time limit can be set in order to kill the operation when/if 
# the NCBI/Entrez server becomes unresponsive.
setTimeLimit(elapsed = 4.9)
try({
  my_q <- 'easyPubMed'
  my_params <- list(q = my_q)
  x <- easyPubMed:::EPM_esearch_basic_q(params = my_params)
  easyPubMed:::EPM_esearch_parse(x)
}, silent = TRUE)
setTimeLimit(elapsed = Inf)

}
\references{
\url{https://www.data-pulse.com/dev_site/easypubmed/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
\keyword{internal}
