% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epm_all_fx.R
\name{EPM_zerofill}
\alias{EPM_zerofill}
\title{Harmonize the Elements of a Vector by Adding Leading Zeros.}
\usage{
EPM_zerofill(x, fillchar = "0")
}
\arguments{
\item{x}{vector (numeric or character).}

\item{fillchar}{string corresponding to a single character. 
This character is going to be added (one or more times) 
in front of each element of the input vector.}
}
\value{
character vector whose elements have all the same size 
(number of characters).
}
\description{
Coerce a vector to character and then harmonize the number of characters 
(nchar) of each element by adding a suitable number of leading
zeroes (or other user-character).
}
\examples{
# Example 1
easyPubMed:::EPM_zerofill(c(1, 100, 1000))
# Example 2
easyPubMed:::EPM_zerofill(c('Hey,', 'hello', 'there!'), '_')


}
\references{
\url{https://www.data-pulse.com/dev_site/easypubmed/}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
\keyword{internal}
