% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{ec.data}
\alias{ec.data}
\title{Data helper}
\usage{
ec.data(df, format = "dataset", header = FALSE, ...)
}
\arguments{
\item{df}{Required chart data as \strong{data.frame}. \cr
For format \emph{dendrogram} df is a \strong{list}, result of \link[stats]{hclust} function.\cr
For format \emph{flame} df is an hierarchical \strong{list} with name,value,children.\cr}

\item{format}{Output list format\cr \itemize{
\item \strong{dataset} = list to be used in \href{https://echarts.apache.org/en/option.html#dataset.source}{dataset} (default), or in \href{https://echarts.apache.org/en/option.html#series-scatter.data}{series.data} (without header). \cr
\item \strong{values} = list for customized \href{https://echarts.apache.org/en/option.html#series-scatter.data}{series.data} \cr
\item \strong{names} = named lists useful for named data like \href{https://echarts.apache.org/en/option.html#series-sankey.links}{sankey links}.
\item \strong{dendrogram} = build series data for Hierarchical Clustering dendrogram
\item \strong{treePC} = build series data for tree charts from parent/children data.frame
\item \strong{treeTT} = build series data for tree charts from data.frame like Titanic.\cr
\item \strong{boxplot} = build dataset and source lists, see Details
\item \strong{borders} = build geoJson string from map_data region borders, see Details
\item \strong{flame} = list of hierarchical series data to be presented by \emph{renderItem}\cr
}}

\item{header}{for dataset, to include the column names or not, default TRUE. Set it to FALSE for \href{https://echarts.apache.org/en/option.html#series-scatter.data}{series.data}.\cr}

\item{...}{optional parameters\cr
Optional parameters for \strong{boxplot} are:\cr
\itemize{
\item \emph{layout} = 'h' for horizontal(default) or 'v' for vertical layout\cr
\item \emph{outliers} boolean to add outlier points (default FALSE)\cr
\item \emph{jitter} value for \link[base]{jitter} of numerical values in second column, default 0 (no scatter). Adds scatter series on top of boxplot.\cr
}

Optional parameter for \strong{names}:\cr
\itemize{
\item \emph{nasep} = single character name separator for nested lists, see Examples. \cr
Purpose is to facilitate conversion from \emph{data.frame} to nested named lists.\cr
}

Optional parameter for \strong{flame}:\cr
\itemize{
\item \emph{name} = name of subtree to search for. \cr
}}
}
\value{
A list for \emph{dataset.source}, \emph{series.data} or other lists:\cr
For boxplot - a named list, see Details and Examples \cr
For dendrogram, treePC, flame - a tree structure, see format in \href{https://echarts.apache.org/en/option.html#series-tree.data}{tree data}
}
\description{
Make data lists from a data.frame
}
\details{
\code{format='boxplot'} requires the first two \emph{df} columns as: \cr
\verb{     }\verb{     } column for the non-computational categorical axis\cr
\verb{     }\verb{     } column with (numeric) data to compute the five boxplot values\cr
Additional grouping is supported on a column after the second. Groups will show in the legend, if enabled.\cr
Returns a \code{list(dataset, series, xAxis, yAxis)} to set params in \link{ec.init}.
Make sure there is enough data for computation, 4+ values per boxplot.\cr\cr
\code{format='treeTT'} expects data.frame \emph{df} columns \emph{pathString,value,(optional itemStyle)} for \link[data.tree]{FromDataFrameTable}.\cr
It will add column 'pct' with value percentage for each node. See example below.\cr\cr
\code{format='borders'} expects \emph{df} columns \emph{long,lat,region,subregion} as in \link[ggplot2]{map_data}.\cr
Result to be used as map in \link{ec.registerMap}. See borders code example in \emph{examples.R}.\cr
This is a slow version for borders, another very fast one is offered as echarty extra, see website.\cr
}
\examples{
library(dplyr)
ds <- iris |> relocate(Species) |>
	 ec.data(format= 'boxplot', jitter= 0.1, layout= 'v')
ec.init(
  dataset= ds$dataset, series= ds$series, xAxis= ds$xAxis, yAxis= ds$yAxis,
  legend= list(show= TRUE), tooltip= list(show= TRUE)
)

hc <- hclust(dist(USArrests), "complete")
ec.init(preset= FALSE,
  series= list(list(
    type= 'tree', orient= 'TB', roam= TRUE, initialTreeDepth= -1,
    data= ec.data(hc, format='dendrogram'),
    layout= 'radial', # symbolSize= ec.clmn(scale= 0.33),
    ## exclude added labels like 'pXX', leaving only the originals
    label= list(formatter= htmlwidgets::JS(
      "function(n) { out= /p\\\\d+/.test(n.name) ? '' : n.name; return out;}"))
  ))
)

# build required pathString,value and optional itemStyle columns
df <- as.data.frame(Titanic) |> rename(value= Freq) |> mutate(
  pathString= paste('Titanic\nSurvival', Survived, Age, Sex, Class, sep='/'),
	 itemStyle= case_when(Survived=='Yes' ~"color='green'", TRUE ~"color='LightSalmon'")) |>
	 select(pathString, value, itemStyle)
ec.init(
	  series= list(list(
		  data= ec.data(df, format='treeTT'),
		  type= 'tree', symbolSize= ec.clmn("(x) => {return Math.log(x)*10}")
	  )),
	  tooltip= list(formatter= ec.clmn('\%@<br>\%@\%','value','pct'))
)

# column itemStyle_color will become itemStyle= list(color=...) in data list
# attribute names separator (nasep) is "_"
df <- data.frame(name= c('A','B','C'), value= c(1,2,3), 
     itemStyle_color= c('chartreuse','lightblue','pink'),
     itemStyle_decal_symbol= c('rect','diamond','none'),
     emphasis_itemStyle_color= c('darkgreen','blue','red')
)
ec.init(series.param= list(type='pie', data= ec.data(df, 'names', nasep='_')))

}
\seealso{
some live \href{https://rpubs.com/echarty/data-models}{code samples}
}
