% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hsim.R
\docType{methods}
\name{hsim}
\alias{hsim}
\alias{hsim,hspec-method}
\title{Simulate multivariate Hawkes process with exponential kernel.}
\usage{
hsim(
  object,
  size = 100,
  lambda_component0 = NULL,
  N0 = NULL,
  Nc0 = NULL,
  verbose = FALSE,
  ...
)

\S4method{hsim}{hspec}(
  object,
  size = 100,
  lambda_component0 = NULL,
  N0 = NULL,
  Nc0 = NULL,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{object}{\code{\link{hspec-class}}. S4 object that specifies the parameter values.}

\item{size}{Number of observations.}

\item{lambda_component0}{Initial values for the lambda component \eqn{\lambda_{ij}}.
Can be a numeric value or a matrix.
Must have the same number of rows and columns as \code{alpha} or \code{beta} in \code{object}.}

\item{N0}{Starting values of N with default value 0.}

\item{Nc0}{Starting values of Nc with default value 0.}

\item{verbose}{Logical. If \code{TRUE}, print progress messages during the simulation. Default is \code{FALSE}.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
\code{\link{hreal}} S3-object, summary of the Hawkes process realization.
}
\description{
The method simulate multivariate Hawkes processes.
The object \code{\link{hspec-class}} contains the parameter values such as \code{mu}, \code{alpha}, \code{beta}.
The mark (jump) structure may or may not be included.
It returns an object of class \code{\link{hreal}} which contains \code{inter_arrival}, \code{arrival},
\code{type}, \code{mark}, \code{N}, \code{Nc}, \code{lambda}, \code{lambda_component}, \code{rambda}, \code{rambda_component}.
}
\examples{

# example 1

mu <- 1; alpha <- 1; beta <- 2
h <- new("hspec", mu=mu, alpha=alpha, beta=beta)
hsim(h, size=100)


# example 2
mu <- matrix(c(0.1, 0.1), nrow=2)
alpha <- matrix(c(0.2, 0.1, 0.1, 0.2), nrow=2, byrow=TRUE)
beta <- matrix(c(0.9, 0.9, 0.9, 0.9), nrow=2, byrow=TRUE)
h <- new("hspec", mu=mu, alpha=alpha, beta=beta)
res <- hsim(h, size=100)
print(res)

}
