% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tzexp.R
\name{tzexp}
\alias{tzexp}
\alias{dtzexp}
\alias{ptzexp}
\alias{qtzexp}
\alias{rtzexp}
\title{Trapezoid + Exponential Distribution}
\usage{
dtzexp(x, a, ell)

ptzexp(q, a, ell)

qtzexp(p, a, ell)

rtzexp(n, a, ell)
}
\arguments{
\item{x, q}{vector of quantiles}

\item{a}{location parameter for transition (must be > 0)}

\item{ell}{rate parameter for exponential decay (must be > 0)}

\item{p}{vector of probabilities}

\item{n}{number of observations}
}
\value{
\itemize{
\item \code{dtzexp} gives the density
\item \code{ptzexp} gives the distribution function
\item \code{qtzexp} gives the quantile function
\item \code{rtzexp} generates random deviates
}
}
\description{
These functions implement a custom distribution combining a trapezoidal section (0 < x < a)
and an exponential tail (\eqn{x \geq a}). The distribution is parameterized by:
\itemize{
\item \code{a}: transition point between trapezoid and exponential
\item \code{ell}: rate parameter for the exponential tail
}
}
\details{
Density, distribution function, quantile function and random generation for a custom trapezoid + exponential distribution.

The trapezoid+exponential distribution has the probability density function:

\deqn{
f(x) = \begin{cases}
0 & \text{if } x \leq 0 \\
\frac{(p\ell - c)}{a} x + c & \text{if } 0 < x < a \\
p\ell e^{-\ell (x - a)} & \text{if } x \geq a
\end{cases}
}

where:
\deqn{
p = \frac{\ell - \frac{a\ell}{3}}{\frac{a^2\ell^2}{6} + \frac{2a\ell}{3} + 1}
}
\deqn{
c = \frac{2 - 2p - p\ell a}{a}
}

The trapezoid+exponential distribution has the following characteristics:
\itemize{
\item Support on \eqn{[0, \infty)}
\item Continuous probability distribution
\item Linear density from 0 to a
\item Exponential decay for x > a
}
}
