% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epe4md_mercado_potencial.R
\encoding{UTF-8}
\name{epe4md_mercado_potencial}
\alias{epe4md_mercado_potencial}
\title{Cria a base do mercado potencial inicial para a adoção.}
\usage{
epe4md_mercado_potencial(
  ano_base,
  filtro_renda_domicilio = "maior_3sm",
  filtro_comercial = NA,
  tx_cresc_grupo_a = 0.016,
  dir_dados_premissas = NA_character_
)
}
\arguments{
\item{ano_base}{numeric. Ano base da projeção. Define o ano em que a função
irá buscar a base de dados. Último ano completo realizado.}

\item{filtro_renda_domicilio}{string. Define o filtro aplicado a consumidores
residenciais, de acordo com a renda mensal do responsável, em salários
mínimos. Permite: "total", "maior_1sm, maior_2sm", "maior_3sm" ou
"maior_5sm". Default igual a "maior_3sm".}

\item{filtro_comercial}{numeric. Fator percentual para definir o nicho do
segmento comercial. Default é calculado pelo modelo com base no nicho
residencial.}

\item{tx_cresc_grupo_a}{numeric. Taxa de crescimento anual dos consumidores
cativos do Grupo A. Default igual a 0.016 representa crescimento
entre 2006 e 2019.}

\item{dir_dados_premissas}{Diretório onde se encontram as premissas. Se esse
parâmetro não for passado, a função usa os dados default que são instalados
com o pacote. É importante que os nomes dos arquivos sejam os mesmos da pasta
default.}
}
\value{
list com dois data.frames. "consumidores" possui o mercado
potencial inicial. "consumidores_totais" possui dados de mercado total.
}
\description{
Cria a base do mercado potencial inicial para a adoção.
}
\examples{

mercado_potencial <- epe4md_mercado_potencial(
  ano_base = 2021,
  filtro_renda_domicilio = "maior_3sm",
  filtro_comercial = NA,
  tx_cresc_grupo_a = 0.016,
  dir_dados_premissas = NA_character_
)
}
