% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epe4md_proj_potencia.R
\encoding{UTF-8}
\name{epe4md_proj_potencia}
\alias{epe4md_proj_potencia}
\title{Realiza a projecao da capacidade instalada de micro e minigeracao distribuida}
\usage{
epe4md_proj_potencia(
  lista_adotantes,
  ano_base,
  dir_dados_premissas = "inst/dados_premissas"
)
}
\arguments{
\item{lista_adotantes}{data.frame. Data.frame que contém dados relativos aos
adotantes.}

\item{ano_base}{numeric. Ano base da projeção. Define o ano em que a função
irá buscar a base de dados. Último ano completo realizado.}

\item{dir_dados_premissas}{Diretório onde se encontram as premissas.
Se esse parâmetro não for passado, a função usa os dados default que são
instalados com o pacote. É importante que os nomes dos arquivos sejam os
mesmos da pasta default.}

}
\value{
list com dois data.frames. "proj_potencia" possui os resultados da
projeção de capacidade instalada de micro e minigeração distribuída.
"part_adotantes" possui o resultado em termos de participação do
número de adotantes frente ao total de unidades consumidoras.
}
\description{
Realiza a projecao da capacidade instalada de micro e minigeracao distribuida
}
\examples{

lista_adotantes <- list(
  structure(
    list(nome_4md = c("CEB", "EQUATORIAL MA", "LIGHT"),
         segmento = c("comercial_at_remoto", "comercial_bt", "comercial_at_remoto"),
         p = c(0.000314088483901221, 0.000326288160094334, 0.01),
         q = c(0.860602105239079, 0.796618861208451, 0.0771175699573262),
         spb = c(0.3, 0.3, 0.3),
         ano = c(2024, 2028, 2022),
         Ft = c(0.917955265426745, 0.992968921614641, 0.137575817915978),
         consumidores = c(12146, 47955, 22878),
         payback = c(5.00924084667372, 4.40202323859729, 8.53878219211533),
         mercado_potencial = c(675.75, 3200.75, 441.5),
         adotantes_ano = c(309, 0, 4),
         adotantes_acum = c(2361, 0, 42),
         fonte_resumo = c("Fotovoltaica", "Eólica", "Fotovoltaica"),
         part_fonte = c(1, 0, 0.186666666666667),
         adotantes_hist = c(NA_real_, NA_real_, NA_real_)),
    row.names = c(NA, -3L),
    class = c("tbl_df", "tbl", "data.frame")),
  structure(
    list(ano = c(2030, 2016, 2020),
         segmento = c("comercial_bt", "residencial", "residencial"),
         adotantes = c(694432, 7214, 357386),
         mercado_potencial = c(620539, 857786, 2931122),
         total_ucs = c(14858570, 66148593.0147109, 71001451.6735913),
         penetracao_total = c(0.0467361260202025, 0.000109057497238009, 0.00503350271826806),
         mercado_nicho = c(2541888, 10668970, 11014026),
         penetracao_nicho = c(0.273195357151849, 0.000676166490298501, 0.0324482618798975),
         penetracao_potencial = c(1.11907873638885, 0.00841002301273278, 0.121928053489415)),
    row.names = c(NA, -3L),
    class = c("tbl_df", "tbl", "data.frame"))
  )

names(lista_adotantes) <- c("proj_adotantes", "part_adotantes")

proj_potencia <- epe4md_proj_potencia(
  lista_adotantes = lista_adotantes,
  ano_base = 2021
)
}
