% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reports.R
\name{create_report_grouped_stats}
\alias{create_report_grouped_stats}
\title{Create grouped disease statistics report}
\usage{
create_report_grouped_stats(data, diseases, y, m, config)
}
\arguments{
\item{data}{Dataframe. Input data with columns:
\itemize{
\item \code{disease} (character)
\item \code{year} (integer)
\item \code{month} (integer)
\item \code{counts} (integer)
}}

\item{diseases}{Dataframe. Diseases to include in the report. Must have column
\code{EpiTrax_name} (character) with diseases to include. Optionally may have column
\code{Group_name} (character) to define disease groupings. If \code{Group_name} is
missing, all diseases will be grouped under "Uncategorized".}

\item{y}{Integer. Report year}

\item{m}{Integer. Report month (1-12)}

\item{config}{List. Report settings}
}
\value{
Dataframe with one row per disease containing:
\itemize{
\item Group: Disease group name
\item Disease: Disease name
\item Monthly counts and rates for current year/month
\item Historical monthly averages and medians
\item Year-to-date counts and historical averages and medians
\item YTD trend indicators
}
}
\description{
'create_report_grouped_stats' generates a comprehensive report with current
and historical statistics for diseases organized by group. The report includes
monthly counts/rates, year-to-date counts, and trend analysis.
}
\details{
Uses the following config options:
\itemize{
\item \code{current_population}
\item \code{avg_5yr_population}
\item \code{rounding_decimals}
\item \code{trend_threshold}
}
}
\examples{
data <- data.frame(
  disease = c("A", "A", "B", "B"),
  year = c(2023, 2024, 2023, 2024),
  month = c(1, 1, 2, 2),
  counts = c(10, 20, 15, 25)
)
diseases <- data.frame(
  EpiTrax_name = c("A", "B", "C"),
  Group_name = c("Group1", "Group1", "Group2")
)
config <- list(
  current_population = 100000,
  avg_5yr_population = 100000,
  rounding_decimals = 1,
  trend_threshold = 0.15
)
create_report_grouped_stats(data, diseases, 2024, 2, config)
}
\seealso{
\code{\link[=create_report_monthly_counts]{create_report_monthly_counts()}}, \code{\link[=create_report_monthly_avgs]{create_report_monthly_avgs()}},
\code{\link[=create_report_monthly_medians]{create_report_monthly_medians()}}, \code{\link[=create_report_ytd_counts]{create_report_ytd_counts()}},
\code{\link[=create_report_ytd_medians]{create_report_ytd_medians()}} which this function uses and \code{\link[=epitraxr_config]{epitraxr_config()}}
for config options
}
