% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agents-methods.R
\name{agents}
\alias{agents}
\alias{get_agents}
\alias{epiworld_agents}
\alias{get_agents.epiworld_model}
\alias{[.epiworld_agents}
\alias{epiworld_agent}
\alias{print.epiworld_agent}
\alias{print.epiworld_agents}
\alias{get_state}
\title{Agents in epiworldR}
\usage{
get_agents(model, ...)

\method{get_agents}{epiworld_model}(model, ...)

\method{[}{epiworld_agents}(x, i)

\method{print}{epiworld_agent}(x, compressed = FALSE, ...)

\method{print}{epiworld_agents}(x, compressed = TRUE, max_print = 10, ...)

get_state(x)
}
\arguments{
\item{model}{An object of class \link{epiworld_model}.}

\item{...}{Ignored}

\item{x}{An object of class \link{epiworld_agents}}

\item{i}{Index (id) of the agent (from 0 to \code{n-1})}

\item{compressed}{Logical scalar. When FALSE, it prints detailed information
about the agent.}

\item{max_print}{Integer scalar. Maximum number of agents to print.}
}
\value{
\itemize{
\item The \code{get_agents} function returns an object of class \link{epiworld_agents}.
}

\itemize{
\item The \code{[} method returns an object of class \link{epiworld_agent}.
}

\itemize{
\item The \code{print} function returns information about each individual agent of
class \link{epiworld_agent}.
}

\itemize{
\item The \code{get_state} function returns the state of the \link{epiworld_agents} object.
}
}
\description{
These functions provide read-access to the agents of the model. The
\code{get_agents} function returns an object of class \link{epiworld_agents} which
contains all the information about the agents in the model. The
\code{get_agent} function returns the information of a single agent.
And the \code{get_state} function returns the state of a single agent.
}
\examples{

model_sirconn <- ModelSIRCONN(
  name                = "COVID-19",
  n                   = 10000,
  prevalence          = 0.01,
  contact_rate        = 5,
  transmission_rate   = 0.4,
  recovery_rate       = 0.95
)

run(model_sirconn, ndays = 100, seed = 1912)

x <- get_agents(model_sirconn) # Storing all agent information into object of
# class epiworld_agents

print(x, compressed = FALSE, max_print = 5) # Displaying detailed information of
# the first 5 agents using
# compressed=F. Using compressed=T
# results in less-detailed
# information about each agent.

x[0] # Print information about the first agent. Substitute the agent of
# interest's position where '0' is.
}
\seealso{
agents
}
\concept{model-utility-functions}
