% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor_data.R
\name{cor_data}
\alias{cor_data}
\alias{dcorr}
\title{Generate Data with a Target Correlation}
\usage{
cor_data(
  x,
  y,
  r,
  method = c("pearson", "kendall", "spearman"),
  ...,
  maxit = 1000
)

dcorr(x, y, r, method = c("pearson", "kendall", "spearman"), ..., maxit = 1000)
}
\arguments{
\item{x}{numeric. Vector of \code{x} values.}

\item{y}{numeric. Vector of \code{y} values.}

\item{r}{numeric. Desired correlation.}

\item{method}{character. Correlation coefficient to compute. Options are \code{"pearson"} (default),
\code{"kendall"}, or \code{"spearman"}.}

\item{...}{Additional arguments passed to \code{\link[stats:cor]{stats::cor()}}.}

\item{maxit}{integer. Maximum number of iterations (default: \code{1000}).}
}
\value{
A two-column matrix with \code{x} and reordered \code{y}.
An attribute \code{interim} stores a matrix of intermediate values, which depends on \code{method}:
\itemize{
\item \strong{\code{pearson}}:
Rows include \eqn{x_i}, \eqn{y_i}, \eqn{x_i - \bar{x}}, \eqn{y_i - \bar{y}},
squared deviations, and cross-products.
\item \strong{\code{kendall}}:
Rows include \eqn{x_i}, \eqn{y_i}, \eqn{p_i} (concordant pairs), and \eqn{q_i} (discordant pairs).
\item \strong{\code{spearman}}:
Rows include \eqn{x_i}, \eqn{y_i}, ranks of \code{x} and \code{y}, and squared rank differences.
}

In all cases, an additional column with row sums is appended.
}
\description{
Rearranges the order of \code{y} to construct a dataset with a target correlation \code{r} between \code{x} and \code{y},
as defined by \code{\link[stats:cor]{stats::cor()}}.
The marginal distributions of \code{x} and \code{y} are preserved, but the achieved correlation may deviate
from the target. The algorithm iteratively adjusts the ordering of \code{y}; increasing \code{maxit}
may improve accuracy if results are unsatisfactory.
}
\examples{
x <- runif(6)
y <- runif(6)
xy <- cor_data(x, y, r = 0.6)
cbind(x, y, xy)

}
