% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_fmt.R
\name{replace_fmt}
\alias{replace_fmt}
\title{Replace}
\usage{
replace_fmt(txt, digits = 2L, ...)
}
\arguments{
\item{txt}{character: text where the replacement is done}

\item{digits}{numeric or list: number of digits to round}

\item{...}{names to replace with values}
}
\value{
A character with replaced names.
}
\description{
In a text it replaces names with:
\itemize{
\item values which are formatted with \code{\link[exams:fmt]{exams::fmt()}}, or
\item strings
}
}
\examples{
replace_fmt("\\\\frac{x}{y}", x=2, y=3)
replace_fmt("\\\\frac{x}{y}", x=2, y=3, digits=0)
replace_fmt("\\\\frac{x}{y}", x=2, y=3, digits=list(0))
replace_fmt("\\\\frac{x}{y}", x=2, y=3, digits=list(2, y=0))
replace_fmt("\\\\frac{x}{y}", x="\\\\\\\\sum_{i=1}^n x_i", y="\\\\\\\\sum_{i=1}^n y_i")
}
