% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addons.r
\name{addons}
\alias{addons}
\alias{installAddon}
\alias{removeAddon}
\alias{.addons}
\title{Test if addons directory exists and if an addon is installed}
\usage{
addons(x = NULL)

installAddon(x, check = TRUE)

removeAddon(x, check = TRUE)

.addons(x)
}
\arguments{
\item{x}{Either \code{NULL} or a character specifying the name of a \strong{GRASS} addons tool. If \code{NULL}, a vector of installed addons is returned. If a character vector is provided, a logical vector is returned, one per value in \code{x} that indicates if the respective addon is installed.}

\item{check}{Logical: If \code{TRUE}, check to see if the addon is available (\code{installAddon()})or if it is installed (\code{removeAddon()}).}
}
\value{
\code{addons()}: Logical. The other functions invisibly return a logical value indicating if the operation succeeded or not.
}
\description{
These functions handle \strong{GRASS} addons, which are optional tools that can be installed. Most functions in \strong{fasterRaster} rely on "base" \strong{GRASS} tools (not addons), but a few do.
\itemize{
\item \code{addons()}: Either lists all installed addons or verifies if one or more specific addons are installed.
\item \code{installAddon()}: Installs a \strong{GRASS} addon. An addon typically only needs installed once. You can install an addon, quit and restart \strong{R}, attach \strong{fasterRaster}, and any installed addons can be used without using this function again.
\item \code{removeAddon()}: Delete an installed addon from your system.
}
}
\examples{
if (grassStarted()) {

# What addons are installed?
addons()

# Is a specific addon installed?
addons(c("v.centerpoint", "fake.addon"))

}
}
\keyword{internal}
