% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_model_helpers.R
\name{compute_uno_c_index}
\alias{compute_uno_c_index}
\title{Compute Uno's C-index (Time-Dependent AUC)}
\usage{
compute_uno_c_index(
  train_time,
  train_status,
  test_time,
  test_status,
  risk_vec,
  tau,
  censor_eval_fn
)
}
\arguments{
\item{train_time}{Numeric vector of training times (used for censor model).}

\item{train_status}{Numeric vector of training statuses (used for censor model).}

\item{test_time}{Numeric vector of test times.}

\item{test_status}{Numeric vector of test statuses.}

\item{risk_vec}{Numeric vector of predicted risk scores for test data.}

\item{tau}{The time horizon \eqn{\tau} for evaluation. If \code{NA} or
\code{<= 0}, the maximum finite test time is used.}

\item{censor_eval_fn}{A function (from \code{create_censor_eval}) that
evaluates the censoring survival function \eqn{G(t)}.}
}
\value{
The computed Uno's C-index, or \code{NA_real_} on failure.
}
\description{
Calculates Uno's C-index (a time-dependent AUC measure) for survival data,
weighted by the inverse probability of censoring (IPCW).
}
\keyword{internal}
