% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{electricity_wind_pwr_production_forecast_daily_upd}
\alias{electricity_wind_pwr_production_forecast_daily_upd}
\title{Wind power generation forecast - updated once a day}
\usage{
electricity_wind_pwr_production_forecast_daily_upd(
  start_time_utc = NA,
  end_time_utc = NA,
  user_key = NA
)
}
\arguments{
\item{start_time_utc}{Start time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{end_time_utc}{End time in UTC. Character array YYYY-MM-ddTHH:mm:ss.sssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/en/instructions}
}
\value{
A data frame object with time series data having period 15 min and unit type MWh/h.
}
\description{
Finnish wind power generation forecasts for the next day. Forecast is updated every day at 12 p.m. EET. Length of the forecast is 36 hours. Overlapping hours are overwritten.The forecast is based on weather forecasts and data about the location, size and capacity of wind turbines. The weather data sourced from multiple providers. The Data before 28.03.2024 is in hourly resolution.
}
\examples{
\dontrun{
library(finnishgrid)
start = "2024-06-01T00:00:00.000Z"  # UTC
end = "2024-06-03T00:00:00.000Z"    # UTC
key = "MY_SUPER_SECRET"
df <- electricity_wind_pwr_production_forecast_daily_upd(start_time_utc = start,
         end_time_utc = end,
         user_key = key)
summary(df)
}
}
\seealso{
https://data.fingrid.fi/en/datasets/246
}
