% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nclust.R
\name{nclust}
\alias{nclust}
\title{No.of clusters}
\usage{
nclust(bmt_output, prob_threshold = 0.5)
}
\arguments{
\item{bmt_output}{output from the \code{\link{bmt}} run}

\item{prob_threshold}{probability threshold. Default is 0.5. Do not change it unless
you know what you are doing. See the referenced paper}
}
\value{
The number of clusters
}
\description{
Estimates the number of clusters from the \code{\link{bmt}} run
}
\details{
Estimates the number of clusters as the number of big merges + 1. The probability threshold
    is an adjustment that renders this estimation process more robust to sampling fluctuations.
    If the sum of the sample frequencies for the two merging clusters in the last big
    merge is less than 50 percent, we do not report any merges and thus are left with just 1 cluster.
    See the referenced paper for more details.
}
\examples{
library(fusionclust)
set.seed(42)
x<- c(rnorm(1000,-2,1), rnorm(1000,2,1))
out<- bmt(x)
k<- nclust(out)

}
\references{
\enumerate{
\item P. Radchenko, G. Mukherjee, Convex clustering via l1 fusion penalization,
 J. Roy. Statist, Soc. Ser. B (Statistical Methodology) (2017)
 doi:10.1111/rssb.12226.
}
}
\seealso{
\code{\link{bmt}}
}
